 ; Ŀ
 ;   Fist: list all text styles and what they are used for                 
 ;   Copyright 1995, 2002, 2004, 2009 by Rocket Software Ltd.              
 ;   The appendage you would like to use on those who use idiotic styles.  
 ; 

 ; Ŀ
 ;   Subroutines:                                                          
 ;   Foofoo - return a list of blocks and the styles each one contains.    
 ;   Pogo - find all styles contained in a named block, includes           
 ;          sublists for sub-blocks: recursive.                            
 ;   Fafa - remove duplicate entries from a list.                          
 ;   Fifi - make the list of all blocks and the styles they contain,       
 ;          which is returned by (pogo) into a list of the main block      
 ;          name and all styles in both it and any sub-blocks.             
 ;   Lulu - find which dimension styles contain which text styles.         
 ;   Stint - find which linetypes contain text styles.                     
 ;   Styg - list text styles and how many text entities are in each.       
 ;   Styf - prints a list of text styles containing big fonts.             
 ;   Also Plester, Plint, and Listi.                                       
 ; Ĵ
 ;   Utility programs (not subroutines):                                   
 ;   Foof - print a list of each block in the drawing with text styles     
 ;          and sub-blocks it contains.                                    
 ;   Stylf - mark all text in a specific style.                            
 ;   Stylst - prints the style tables.                                     
 ; 

 ; Ŀ
 ;   Foof - print a list of each block in the drawing with text styles     
 ;   and sub-blocks it contains.                                           
 ; 
 (DEFUN C:FOOF (/ bldat rew blnam blist num alist)
  (setq rew T)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 bldat)))
         (setq blist (cons blnam blist)))
  (setq blist (acad_strlsort blist))
  (setq num 0)
  (while (setq blnam (nth num blist))
         (setq num (1+ num))
         (setq alist (pogo blnam))
         (print alist))
 (princ))
 ; Ŀ
 ;   Foof end.                                                             
 ; 

 ; Ŀ
 ;   FooFoo.                                                               
 ; 
 (DEFUN FOOFOO (/ bldat rew blnam alist malist)
  (setq rew T)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq blnam (cdr (assoc 2 bldat)))
         (setq alist (pogo blnam))
         (setq alist (fifi alist))
         (setq alist (fafa alist))
         (if alist (setq malist (cons (cons blnam alist) malist))))
 malist)
 ; Ŀ
 ;   FooFoo end.                                                           
 ; 

 ; Ŀ
 ;   Plint: print each sublist in a list, one per line, add text.          
 ;   Arguments: Pint, a list.                                              
 ;              Frint, the leading text.                                   
 ;              Int, text to go between the first and other elements.      
 ;   Assumes that the sublists contain only text strings.                  
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN PLINT (pint frint int sint / rint)
  (foreach rint pint
           (write-line (strcat frint (car rint) int (listi (cdr rint) sint))))
 (princ))
 ; Ŀ
 ;   Plint end.                                                            
 ; 

 ; Ŀ
 ;   Plester: print each element in a list, one per line.                  
 ;   Takes one argument, a list.                                           
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN PLESTER (pint / rint)
  (foreach rint pint (print rint))
 (princ))
 ; Ŀ
 ;   Plester end.                                                          
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
                   (if (= (type astr) 'INT) (setq astr (itoa astr)))
                   (setq thestr (strcat thestr sepstr astr)))
                    alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Fafa - remove duplicate entries from a list.                          
 ;   Arguments: Alist, a list.                                             
 ;   Returns a list.                                                       
 ; 
 (DEFUN FAFA (alist / sub)
  (repeat (length alist)
          (setq sub (car alist))
          (setq alist (cdr alist))
          (if (not (member sub alist))
              (setq alist (append alist (list sub)))))
 alist)
 ; Ŀ
 ;   FaFa end.                                                             
 ; 

 ; Ŀ
 ;   Fifi - rehash the list returned by Pogo into a list of all styles     
 ;   contained in the main block.                                          
 ;   Arguments: Alist, a list.                                             
 ;   Returns a list of text style.                                         
 ;   Calls only itself.  (Recursive.)                                      
 ; 
 (DEFUN FIFI (alist / typ allst sub gnulst allst)
  (setq alist (cdr alist))
  (while (setq sub (car alist))
         (setq alist (cdr alist))
         (setq typ (type sub))
         (cond ((= typ 'STR)
                (setq allst (cons sub allst)))
               ((= typ 'LIST)
                (setq gnulst (fifi sub))
                (setq allst (append gnulst allst)))))
 allst)
 ; Ŀ
 ;   FiFi end.                                                             
 ; 

 ; Ŀ
 ;   Pogo - find which text styles are used in which blocks: recursive.    
 ;   Arguments: a block name.                                              
 ;   Returns a list:                                                       
 ;   ((Block style1 (sub-block (block2 style) style) style2 (sub etc.)...) 
 ; 
 (DEFUN POGO (blnam / bldata blist enam entt etype txstyl malist)
  (setq blist (list blnam))
  (setq blnam (strcat (strcase (substr blnam 1 1))
              (strcase (substr blnam 2) t)))
 ; Ŀ
 ;   See if the block contains text, attdefs or blocks.                    
 ; 
  (setq bldata (tblsearch "block" blnam))
  (setq enam (cdr (assoc -2 bldata)))
  (while enam
         (setq etype (cdr (assoc 0 (setq entt (entget enam))))) 
         (cond ((= etype "INSERT")
                (setq subnam (cdr (assoc 2 entt)))
                (setq blist (append blist (list (pogo subnam)))))
               ((member etype '("TEXT" "ATTDEF"))
                (setq txstyl (cdr (assoc 7 (entget enam))))
 ; Ŀ
 ;   Check to see if the style name is already part of the list.           
 ;   Remove the first element before checking so that a text style which   
 ;   is named after the block isn't ignored.                               
 ; 
                (if (not (member txstyl (cdr blist)))
                    (setq blist (append blist (list txstyl))))))
         (setq enam (entnext enam)))
 blist)
 ; Ŀ
 ;   Pogo end.                                                             
 ; 

 ; Ŀ
 ;   Lulu - find out which text styles are used by dimension styles.       
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns a list: ((dimstyle text_style1 style2 etc) ...)               
 ; 
 (DEFUN LULU (/ rewind dimst stynam stylst sub dimst malist)
  (setq rewind T)
  (while (setq dimst (tblnext "dimstyle" rewind))
         (setq rewind ())
         (setq stynam (cdr (assoc 2 dimst)))
         (setq stylst (list stynam))
         (while (setq sub (car dimst))
                (setq dimst (cdr dimst))
                (if (= (car sub) 340)
                    (progn
                         (setq cursty (cdr (assoc 2 (entget (cdr sub)))))
                         (if (not (member cursty (cdr stylst)))
                             (setq stylst (append stylst (list cursty)))))))
         (if (cadr stylst) (setq malist (cons stylst malist))))
 malist)
 ; Ŀ
 ;   Lulu end.                                                             
 ; 

 ; Ŀ
 ;   Stint - see if any linetypes contain characters/shapes.               
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns a list: ((linetype1 text_style1 style2 etc) ...)              
 ; 
 (DEFUN STINT (/ rewind cline ltnam tenam ltlist sub lent styl malist)
  (setq rewind T)
  (while (setq cline (tblnext "ltype" rewind))
         (setq ltnam (cdr (assoc 2 cline)))
         (setq tenam (tblobjname "ltype" ltnam))
         (setq ltlist (entget tenam))
         (setq ltlist (cdr ltlist)) ; ditch first = this list -1 group (ename)
         (setq stylst ())
         (while (setq sub (car ltlist))
                (setq ltlist (cdr ltlist))
                (if (= (type (cdr sub)) 'ENAME)
                    (progn
                         (setq lent (entget (cdr sub)))
                         (if (and (= (cdr (assoc 0 lent)) "STYLE")
                                  (setq styl (cdr (assoc 2 lent))))
                             (progn
                                  (setq font (cdr (assoc 3 lent)))
                                  (if (= styl "")
                                      (setq styl (strcat "*/" font))
                                      (setq styl (strcat styl "/" font)))
                                  (cond ((null stylst)
                                         (setq stylst (list ltnam styl)))
                                        ((not (member styl (cdr stylst)))
                                         (setq stylst (append stylst
                                                           (list styl))))))))))
         (if stylst (setq malist (cons stylst malist)))
         (setq rewind ()))
 malist)
 ; Ŀ
 ;   Stint end.                                                            
 ; 

 ; Ŀ
 ;   Styg - get a list of text styles and the number of entities in each.  
 ;   Takes no arguments, calls nothing, returns a list.                    
 ; 
 (DEFUN STYG (/ rew nxstyl stylst num ss len sub)
  (setq rew t)
 ; Ŀ
 ;   Get a list of text styles.                                            
 ; 
  (while (setq nxstyl (tblnext "style" rew))
         (setq nxfont (cdr (assoc 3 nxstyl)))
         (setq nxstyl (cdr (assoc 2 nxstyl)))
 ; Ŀ
 ;   Get the total number of text entities in the style.                   
 ; 
         (if (setq ss (ssget "X" (list (cons 7 nxstyl))))
             (setq len (sslength ss))
             (setq len 0))
 ; Ŀ
 ;   Make the sublist.                                                     
 ; 
         (if (= nxstyl "") (setq nxstyl "*"))  ; ?
         (setq sub (list nxstyl nxfont len))
         (setq stylst (cons sub stylst))
         (setq rew ()))
 ; Ŀ
 ;   Return a list of both lists.                                          
 ; 
  stylst)
 ; Ŀ
 ;   Styg end.                                                             
 ; 

 ; Ŀ
 ;   Stylst: prints the style tables.                                      
 ;   Takes no arguments, calls nothing, returns nothing.                   
 ; 
 (DEFUN C:STYLST (/ reww stylc)
  (setq reww t)
  (while (setq stylc (tblnext "style" reww))
         (setq reww ())
         (print stylc))
 (princ))
 ; Ŀ
 ;   Stylst end.                                                           
 ; 

 ; Ŀ
 ;   Styf: prints a list of text styles containing big fonts.              
 ;   Takes no arguments, calls nothing, returns nothing.                   
 ; 
 (DEFUN STYF (/ reww stylc stlnam phont)
  (setq reww t)
  (while (setq stylc (tblnext "style" reww))
         (setq reww ())
         (if (/= (setq bigfnt (cdr (assoc 4 stylc))) "")
             (progn
                  (setq stlnam (cdr (assoc 2 stylc)))
                  (setq phont (cdr (assoc 3 stylc)))
                  (prompt (strcat "Style " stlnam " uses font " phont
                                  " and big font " bigfnt ".\n")))))
 (princ))
 ; Ŀ
 ;   Styf end.                                                             
 ; 

 ; Ŀ
 ;   Stylf - mark all text in a specific style.                            
 ; 
 (DEFUN C:STYLF ( / num bl ss rad len so txa pa)
  (setq num 0)
  (setq bl (getstring "\nStyle to find or <Return> for Standard: "))
  (if (= bl "")
      (setq ss (ssget "X" '((7 . "Standard"))))
      (setq ss (ssget "X" (list (cons 7 bl)))))
  (if ss
     (progn
          (if (null (setq rad (getdist (getvar "viewctr")
                                     "Marker length (<Return> for preset): ")))
              (setq rad (/ (getvar "viewsize") 20)))
          (setq len (strcat "/" (itoa (sslength ss))))
          (while (setq so (ssname ss 0))
                 (setq txa (entget so))
                 (setq num (1+ num))
                 (grtext -2 (strcat (itoa num) len))
                 (setq pa (cdr (assoc 10 txa)))
                 (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
                 (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 7)
                 (ssdel so ss))
          (write-line (strcat "\nText entities found: " (itoa num)))
          (setq ss nil))
     (write-line "\nCan't find any text in that style. "))
 (princ))
 ; Ŀ
 ;   Subroutine Stylf end.                                                 
 ; 

 ; Ŀ
 ;   Fist.                                                                 
 ; 
 (DEFUN C:FIST ()
  (textscr)
  (prompt (strcat "Current text style is " (getvar "textstyle") ".\n"))
  (prompt "Styles labelled * use shape fonts and are not named.\n")
  (prompt "Use Stylf to locate text in a given style.\n")
  (plint (styg) "Text style " " uses font " ".  Text entities: ")
  (write-line "") 
 ; (plester (foofoo))
  (prompt "Styles listed in blocks may belong to the block or to a sub-block.\n")
  (prompt "Use Foof to list blocks and sub-blocks with text styles they contain.\n")
  (plint (foofoo) "Block " " contains styles: " ", ")
  (write-line "")
  (plint (lulu) "Dimstyle " " contains text styles: " ", ")
  (write-line "")
  (plint (stint) "Linetype " " contains text styles: " ", ")
  (styf)
 (princ))